package cool.mtc.core.util;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

/**
 * @author 明河
 */
public abstract class DateUtil {

    /**
     * LocalDateTime 转 Date
     */
    public static Date localDateTimeToDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    /**
     * Date 转 LocalDateTime
     */
    public static LocalDateTime dateToLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    /**
     * 今天的结束时间
     */
    public static LocalDateTime endToday() {
        return endDay(LocalDateTime.now());
    }

    /**
     * 一天结束时间
     */
    public static LocalDateTime endDay(LocalDateTime day) {
        return day.withHour(23).withMinute(59).withSecond(59).withNano(999999999);
    }
}
