package cool.mtc.core.util;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author 明河
 */
public abstract class StringUtil {
    public static final String EMPTY = "";
    public static final String HYPHEN = "-";
    public static final String UNDERLINE = "_";
    public static final String POINT = ".";
    public static final String SLASH = "/";

    private static final Pattern PATTERN_UNDERSCORE = Pattern.compile("_(\\w)");

    /**
     * 判断字符串是否为空，当str为空或者空字符串时，结果为true
     */
    public static boolean isEmpty(String str) {
        return null == str || str.trim().isEmpty();
    }

    /**
     * {@link StringUtil#isEmpty(String)}的对立方法
     */
    public static boolean isNotEmpty(String str) {
        return !isEmpty(str);
    }

    public static String ifNull(String str) {
        return ifNull(str, EMPTY);
    }

    public static String ifNull(String str, String replacement) {
        return null == str ? replacement : str;
    }

    public static String ifEmpty(String str) {
        return ifEmpty(str, EMPTY);
    }

    public static String ifEmpty(String str, String replacement) {
        return isEmpty(str) ? replacement : str;
    }

    /**
     * 下划线转驼峰
     */
    public static String lineToHump(String str) {
        str = str.toLowerCase();
        Matcher matcher = PATTERN_UNDERSCORE.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    /**
     * 字节数组转16进制字符串
     */
    public static String bytesToHex(byte[] bytes) {
        return new BigInteger(1, bytes).toString(16);
    }
}
