/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.core.util;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringUtil {
    public static final String EMPTY = "";
    public static final String HYPHEN = "-";
    public static final String UNDERLINE = "_";
    public static final String POINT = ".";
    public static final String SLASH = "/";
    private static final Pattern PATTERN_UNDERSCORE = Pattern.compile("_(\\w)");

    public static boolean isEmpty(String str) {
        return null == str || str.trim().isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static String ifNull(String str) {
        return StringUtil.ifNull(str, EMPTY);
    }

    public static String ifNull(String str, String replacement) {
        return null == str ? replacement : str;
    }

    public static String ifEmpty(String str) {
        return StringUtil.ifEmpty(str, EMPTY);
    }

    public static String ifEmpty(String str, String replacement) {
        return StringUtil.isEmpty(str) ? replacement : str;
    }

    public static String lineToHump(String str) {
        str = str.toLowerCase();
        Matcher matcher = PATTERN_UNDERSCORE.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String bytesToHex(byte[] bytes) {
        return new BigInteger(1, bytes).toString(16);
    }
}

