package cool.mtc.core.exception;

import cool.mtc.core.result.Result;
import lombok.Getter;

/**
 * @author 明河
 */
@Getter
public class CustomException extends RuntimeException {
    private final Result<Object> result;

    public CustomException(Result<Object> result) {
        this(result, result.getMsg());
    }

    public CustomException(Result<Object> result, String msg) {
        super(msg);
        this.result = result.newInstance().msg(msg);
    }
}
