package cool.mtc.core.result;

/**
 * @author 明河
 */
public abstract class ResultConstant {

    public static final Result<Object> OK = Result.of(0, "成功");
    public static final Result<Object> ERROR = Result.of(-1, "错误");

    // region 阿里巴巴Java开发手册错误码列表
    // A01 用户注册错误
    public static final Result<Object> A0100 = Result.of(110100, "用户注册错误");
    public static final Result<Object> A0110 = Result.of(110110, "用户名校验失败");
    public static final Result<Object> A0120 = Result.of(110120, "密码校验失败");
    public static final Result<Object> A0130 = Result.of(110130, "验证码错误");
    // A02 用户登录异常
    public static final Result<Object> A0200 = Result.of(110200, "用户登录异常");
    public static final Result<Object> A0201 = Result.of(110201, "用户账户不存在");
    public static final Result<Object> A0210 = Result.of(110210, "用户密码错误");
    // A03 访问权限异常
    public static final Result<Object> A0300 = Result.of(110300, "访问权限异常");
    public static final Result<Object> A0301 = Result.of(110301, "访问未授权");
    public static final Result<Object> A0311 = Result.of(110311, "授权已过期");
    // A04 用户请求参数错误
    public static final Result<Object> A0400 = Result.of(110400, "用户请求参数错误");
    public static final Result<Object> A0401 = Result.of(110401, "包含非法恶意跳转链接");
    public static final Result<Object> A0402 = Result.of(110402, "无效的用户输入");
    public static final Result<Object> A0410 = Result.of(110410, "请求必填参数为空");
    // endregion
}
