/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.core.result;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import cool.mtc.core.result.ResultConstant;
import java.util.Arrays;

public class Result<T> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private int code;
    private String msg;
    private T data;
    @JsonIgnore
    private Object[] args;

    public static <T> Result<T> ofData(T data) {
        return Result.of(ResultConstant.OK.getCode(), ResultConstant.OK.getMsg(), data);
    }

    public static <T> Result<T> of(int code, String msg) {
        return Result.of(code, msg, null);
    }

    public static <T> Result<T> of(int code, String msg, T data) {
        return Result.of(code, msg, data, null);
    }

    public Result<T> newInstance() {
        return new Result<T>(this.getCode(), this.getMsg(), this.getData(), this.getArgs());
    }

    public Result<T> args(Object ... args) {
        this.args = args;
        return this;
    }

    public Result<T> msg(String msg) {
        this.msg = msg;
        return this;
    }

    public String toJson() {
        try {
            return MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException ex) {
            return null;
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    @JsonIgnore
    public void setArgs(Object[] args) {
        this.args = args;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        return Arrays.deepEquals(this.getArgs(), other.getArgs());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArgs());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", args=" + Arrays.deepToString(this.getArgs()) + ")";
    }

    public Result() {
    }

    private Result(int code, String msg, T data, Object[] args) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.args = args;
    }

    public static <T> Result<T> of(int code, String msg, T data, Object[] args) {
        return new Result<T>(code, msg, data, args);
    }
}

