/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.core.util;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;

public abstract class DateUtil {
    public static Date localDateTimeToDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDateTime startOfDay(LocalDateTime localDateTime) {
        if (null == localDateTime) {
            return null;
        }
        return LocalDateTime.of(localDateTime.toLocalDate(), LocalTime.MIN);
    }

    public static Date startOfDay(Date date) {
        if (null == date) {
            return null;
        }
        LocalDateTime localDateTime = DateUtil.dateToLocalDateTime(date);
        LocalDateTime endLocalDateTime = DateUtil.startOfDay(localDateTime);
        return DateUtil.localDateTimeToDate(endLocalDateTime);
    }

    public static LocalDateTime endOfDay(LocalDateTime localDateTime) {
        if (null == localDateTime) {
            return null;
        }
        return LocalDateTime.of(localDateTime.toLocalDate(), LocalTime.MAX);
    }

    public static Date endOfDay(Date date) {
        if (null == date) {
            return null;
        }
        LocalDateTime localDateTime = DateUtil.dateToLocalDateTime(date);
        LocalDateTime endLocalDateTime = DateUtil.endOfDay(localDateTime);
        return DateUtil.localDateTimeToDate(endLocalDateTime);
    }
}

