/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.core.util;

import cool.mtc.core.util.CollectionUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcUtil {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtil.class);
    private static final List<Class<?>> LIST = new ArrayList();

    public static <T> List<T> exec(DbTypeEnum dbType, String ip, String port, String db, String username, String password, String sql, Object[] params, Class<T> targetClass) throws SQLException, ClassNotFoundException {
        Connection connection = JdbcUtil.getConnection(dbType, ip, port, db, username, password);
        return JdbcUtil.exec(connection, sql, params, targetClass);
    }

    public static <T> List<T> exec(String dbUrl, String username, String password, String sql, Object[] params, Class<T> targetClass) throws SQLException {
        Connection connection = JdbcUtil.getConnection(dbUrl, username, password);
        return JdbcUtil.exec(connection, sql, params, targetClass);
    }

    public static <T> List<T> exec(Connection connection, String sql, Object[] params, Class<T> targetClass) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        if (CollectionUtil.isNotEmpty(Arrays.asList(params))) {
            for (int i = 0; i < params.length; ++i) {
                statement.setObject(i + 1, params[i]);
            }
        }
        ResultSet resultSet = statement.executeQuery();
        List<T> list = JdbcUtil.transResultSetToObject(resultSet, targetClass);
        JdbcUtil.close(resultSet);
        JdbcUtil.close(statement);
        JdbcUtil.close(connection);
        return list;
    }

    public static Connection getConnection(DbTypeEnum dbType, String db, String username, String password) throws SQLException, ClassNotFoundException {
        return JdbcUtil.getConnection(dbType, dbType.getDefaultIp(), dbType.getDefaultPort(), db, username, password);
    }

    public static Connection getConnection(DbTypeEnum dbType, String ip, String port, String db, String username, String password) throws ClassNotFoundException, SQLException {
        Class.forName(dbType.getDriverClassName());
        return JdbcUtil.getConnection(JdbcUtil.getDBUrl(dbType, ip, port, db), username, password);
    }

    public static Connection getConnection(String dbUrl, String username, String password) throws SQLException {
        return DriverManager.getConnection(dbUrl, username, password);
    }

    public static void close(Connection connection) {
        if (null == connection) {
            return;
        }
        try {
            connection.close();
        }
        catch (SQLException ex) {
            log.error("\u5173\u95edConnection\u5931\u8d25", (Throwable)ex);
        }
    }

    public static void close(Statement statement) {
        if (null == statement) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException ex) {
            log.error("\u5173\u95edStatement\u5931\u8d25", (Throwable)ex);
        }
    }

    public static void close(ResultSet resultSet) {
        if (null == resultSet) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException ex) {
            log.error("\u5173\u95edResultSet\u5931\u8d25", (Throwable)ex);
        }
    }

    private static <T> List<T> transResultSetToObject(ResultSet resultSet, Class<T> clazz) throws SQLException {
        if (null == resultSet) {
            return new ArrayList();
        }
        ArrayList<T> list = new ArrayList<T>();
        if (LIST.contains(clazz)) {
            while (resultSet.next()) {
                list.add(resultSet.getObject(1, clazz));
            }
            return list;
        }
        Field[] fields = clazz.getDeclaredFields();
        while (resultSet.next()) {
            try {
                T t = clazz.newInstance();
                for (Field field : fields) {
                    Object obj;
                    field.setAccessible(true);
                    Field targetField = t.getClass().getDeclaredField(field.getName());
                    try {
                        obj = resultSet.getObject(field.getName(), field.getType());
                    }
                    catch (SQLException ex) {
                        log.warn("\u4ece\u67e5\u8be2\u7ed3\u679c\u4e2d\u8bfb\u53d6\u5c5e\u6027\u503c[{}]\u5931\u8d25\u3002", (Object)field.getName());
                        continue;
                    }
                    targetField.setAccessible(true);
                    targetField.set(t, obj);
                }
                list.add(t);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                log.error("\u67e5\u8be2\u7ed3\u679c\u8f6c\u6362\u5931\u8d25\u3002", (Throwable)ex);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        return list;
    }

    private static String getDBUrl(DbTypeEnum dbType, String ip, String port, String db) {
        return dbType.getUrlTemplate().replace("{ip}", ip).replace("{port}", port).replace("{db}", db);
    }

    static {
        LIST.add(String.class);
        LIST.add(Integer.class);
    }

    public static enum DbTypeEnum {
        MYSQL("com.mysql.jdbc.Driver", "jdbc:mysql://{ip}:{port}/{db}?useSSL=false", "localhost", "3306");

        private final String driverClassName;
        private final String urlTemplate;
        private final String defaultIp;
        private final String defaultPort;

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public String getUrlTemplate() {
            return this.urlTemplate;
        }

        public String getDefaultIp() {
            return this.defaultIp;
        }

        public String getDefaultPort() {
            return this.defaultPort;
        }

        private DbTypeEnum(String driverClassName, String urlTemplate, String defaultIp, String defaultPort) {
            this.driverClassName = driverClassName;
            this.urlTemplate = urlTemplate;
            this.defaultIp = defaultIp;
            this.defaultPort = defaultPort;
        }
    }
}

