/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.core.util;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringUtil {
    public static final String EMPTY = "";
    public static final String HYPHEN = "-";
    public static final String UNDERLINE = "_";
    public static final String POINT = ".";
    public static final String SLASH = "/";
    private static final Pattern PATTERN_UNDERSCORE = Pattern.compile("_(\\w)");

    public static boolean isEmpty(String str) {
        return null == str || str.trim().isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static String ifNull(Object obj) {
        return StringUtil.ifNull(obj, EMPTY);
    }

    public static String ifNull(Object obj, String replacement) {
        return null == obj ? replacement : obj.toString();
    }

    public static String ifEmpty(String str) {
        return StringUtil.ifEmpty(str, EMPTY);
    }

    public static String ifEmpty(String str, String replacement) {
        return StringUtil.isEmpty(str) ? replacement : str;
    }

    public static String lineToHump(String str) {
        str = str.toLowerCase();
        Matcher matcher = PATTERN_UNDERSCORE.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String bytesToHex(byte[] bytes) {
        return new BigInteger(1, bytes).toString(16);
    }

    public static String fixPath(String path) {
        if (StringUtil.isEmpty(path)) {
            return SLASH;
        }
        if (path.endsWith(SLASH)) {
            return path;
        }
        return path + SLASH;
    }

    public static String concatPath(String ... paths) {
        if (null == paths || paths.length == 0) {
            return EMPTY;
        }
        StringBuilder pathSB = new StringBuilder();
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (StringUtil.isEmpty(path)) continue;
            if (i == paths.length - 1 || path.endsWith(SLASH)) {
                pathSB.append(path);
            } else {
                pathSB.append(path).append(SLASH);
            }
            if (i <= 0 || !path.startsWith(SLASH)) continue;
            pathSB.append(path.replaceAll("^/+", EMPTY));
        }
        return pathSB.toString();
    }
}

