/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.io.upload;

import cool.mtc.core.result.Result;
import cool.mtc.core.result.ResultConstant;
import cool.mtc.core.util.StringUtil;
import cool.mtc.io.upload.UploadProperties;
import cool.mtc.io.upload.exception.UploadConfigException;
import cool.mtc.io.upload.exception.UploadParamException;
import cool.mtc.io.upload.model.UploadInfo;
import cool.mtc.io.upload.model.UploadResult;
import cool.mtc.io.util.ResourceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

public class UploadTemplate {
    private final UploadProperties uploadProperties;
    public static final Map<String, UploadProperties.Type> UPLOAD_TYPE_MAP = new HashMap<String, UploadProperties.Type>();
    public static final Map<String, UploadResult> UPLOAD_RESULT_MAP = new HashMap<String, UploadResult>();

    public UploadTemplate(UploadProperties uploadProperties) {
        this.uploadProperties = uploadProperties;
        uploadProperties.getTypes().forEach(item -> UPLOAD_TYPE_MAP.put(item.getType(), (UploadProperties.Type)item));
    }

    public void upload(UploadInfo uploadInfo) throws IOException {
        this.handleCheckUploadInfoCorrect(uploadInfo);
        if (this.isChunkUpload(uploadInfo.getType())) {
            uploadInfo.setChunk(true);
            UploadResult result = UPLOAD_RESULT_MAP.get(uploadInfo.getChunkId());
            if (null == result) {
                UPLOAD_RESULT_MAP.put(uploadInfo.getChunkId(), new UploadResult(uploadInfo.getChunkTotal()));
            }
        }
        this.updateUploadInfo(uploadInfo);
        this.save(uploadInfo);
    }

    private void handleCheckUploadInfoCorrect(UploadInfo uploadInfo) {
        Optional.ofNullable(uploadInfo.getFile()).orElseThrow(() -> new UploadParamException("mtc.upload.file.required"));
        Optional.ofNullable(uploadInfo.getType()).orElseThrow(() -> new UploadParamException("mtc.upload.type.required"));
        Optional.ofNullable(UPLOAD_TYPE_MAP.get(uploadInfo.getType())).orElseThrow(() -> new UploadConfigException((Result<Object>)ResultConstant.ERROR.newInstance().msg("mtc.upload.type.non_config").args(new Object[]{uploadInfo.getType()})));
        UploadProperties.Type type = UPLOAD_TYPE_MAP.get(uploadInfo.getType());
        List<String> allowExtensionList = type.getAllowExtensions();
        if (!allowExtensionList.contains("*")) {
            String extension;
            String fileName = StringUtil.ifEmpty((String)uploadInfo.getFile().getOriginalFilename(), (String)uploadInfo.getFile().getName());
            String string = extension = fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".") + 1) : "";
            if (allowExtensionList.stream().noneMatch(item -> item.equals(extension))) {
                throw new UploadParamException((Result<Object>)ResultConstant.ERROR.newInstance().msg("mtc.upload.extension.error").args(new Object[]{extension}));
            }
        }
        if (this.isChunkUpload(uploadInfo.getType())) {
            if (StringUtil.isEmpty((String)uploadInfo.getChunkId())) {
                throw new UploadParamException("mtc.upload.chunk.id.non_found");
            }
            Optional.ofNullable(uploadInfo.getChunkTotal()).orElseThrow(() -> new UploadParamException("mtc.upload.chunk.total.non_found"));
            Optional.ofNullable(uploadInfo.getChunkTotal()).orElseThrow(() -> new UploadParamException("mtc.upload.chunk.index.non_found"));
            if (uploadInfo.getChunkTotal().equals(uploadInfo.getChunkIndex()) ? uploadInfo.getFile().getSize() > type.getInuseChunk(this.uploadProperties).getSize().toBytes() : uploadInfo.getFile().getSize() != type.getInuseChunk(this.uploadProperties).getSize().toBytes()) {
                throw new UploadParamException("mtc.upload.chunk.size.error");
            }
        } else if (uploadInfo.getFile().getSize() > type.getMaxSize().toBytes()) {
            Result result = ResultConstant.ERROR.newInstance().msg("mtc.upload.size.bigger").args(new Object[]{uploadInfo.getFile().getSize(), type.getMaxSize().toBytes()});
            throw new UploadParamException((Result<Object>)result);
        }
    }

    private void updateUploadInfo(UploadInfo uploadInfo) throws IOException {
        MultipartFile file = uploadInfo.getFile();
        String fileName = StringUtil.ifEmpty((String)file.getOriginalFilename(), (String)file.getName());
        uploadInfo.setOriginalName(fileName);
        if (fileName.contains(".")) {
            uploadInfo.setExtension(fileName.substring(fileName.lastIndexOf(".") + 1));
        }
        if (StringUtil.isEmpty((String)uploadInfo.getName())) {
            uploadInfo.setName(UUID.randomUUID().toString() + "." + uploadInfo.getExtension());
        }
        uploadInfo.setMime(file.getContentType());
        if (!uploadInfo.isChunk()) {
            uploadInfo.setMd5(ResourceUtil.md5(file.getResource()));
            uploadInfo.setSha256(ResourceUtil.sha256(file.getResource()));
        }
        this.updateUploadFilePath(uploadInfo);
    }

    private void updateUploadFilePath(UploadInfo uploadInfo) {
        UploadProperties.Type type = UPLOAD_TYPE_MAP.get(uploadInfo.getType());
        if (uploadInfo.isChunk()) {
            UploadProperties.Chunk chunk = type.getInuseChunk(this.uploadProperties);
            String chunkBasePath = chunk.getInusePath(this.uploadProperties);
            String chunkRelativePath = uploadInfo.getType() + "/" + uploadInfo.getChunkId() + "/" + uploadInfo.getName() + "_" + uploadInfo.getChunkTotal() + "-" + uploadInfo.getChunkIndex();
            uploadInfo.setChunkPath(chunkBasePath + chunkRelativePath);
        } else {
            uploadInfo.setRelativePath(type.isUseUuidFolder() ? ResourceUtil.plusUUIDFolder(uploadInfo.getName()) : uploadInfo.getName());
            uploadInfo.setAbsolutePath(type.getInusePath(this.uploadProperties) + uploadInfo.getRelativePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(UploadInfo uploadInfo) throws IOException {
        InputStream inputStream = uploadInfo.getFile().getInputStream();
        try {
            String targetFilePath = uploadInfo.isChunk() ? uploadInfo.getChunkPath() : uploadInfo.getAbsolutePath();
            FileOutputStream outputStream = this.getTargetFileOutputStream(targetFilePath);
            try {
                FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                if (uploadInfo.isChunk()) {
                    UploadResult result = UPLOAD_RESULT_MAP.get(uploadInfo.getChunkId());
                    result.setCompleteNum(result.getCompleteNum() + 1);
                    if (result.getTotal() == result.getCompleteNum()) {
                        this.merge(uploadInfo);
                    }
                } else {
                    uploadInfo.setComplete(true);
                }
            }
            finally {
                if (Collections.singletonList(outputStream).get(0) != null) {
                    ((OutputStream)outputStream).close();
                }
            }
        }
        finally {
            if (Collections.singletonList(inputStream).get(0) != null) {
                inputStream.close();
            }
        }
    }

    private void merge(UploadInfo uploadInfo) throws IOException {
        if (!uploadInfo.isChunk()) {
            return;
        }
        File chunkFile = ResourceUtil.getResource(uploadInfo.getChunkPath()).getFile();
        if (!chunkFile.exists()) {
            return;
        }
        File chunkFolder = chunkFile.getParentFile();
        File[] files = chunkFolder.listFiles();
        UploadResult result = UPLOAD_RESULT_MAP.get(uploadInfo.getChunkId());
        if (null == files || files.length == 0 || files.length != uploadInfo.getChunkTotal() || result.isComplete()) {
            return;
        }
        UploadProperties.Type type = UPLOAD_TYPE_MAP.get(uploadInfo.getType());
        uploadInfo.setRelativePath(type.isUseUuidFolder() ? ResourceUtil.plusUUIDFolder(uploadInfo.getName()) : uploadInfo.getName());
        uploadInfo.setAbsolutePath(type.getInusePath(this.uploadProperties) + uploadInfo.getRelativePath());
        FileChannel outChannel = this.getTargetFileOutputStream(uploadInfo.getAbsolutePath()).getChannel();
        for (File file : files) {
            FileChannel inChannel = new FileInputStream(file).getChannel();
            inChannel.transferTo(0L, inChannel.size(), outChannel);
            inChannel.close();
            if (!type.getInuseChunk(this.uploadProperties).isDeleteAfterComplete()) continue;
            file.delete();
        }
        outChannel.close();
        chunkFolder.delete();
        uploadInfo.setMd5(ResourceUtil.md5(ResourceUtil.getResource(uploadInfo.getAbsolutePath())));
        uploadInfo.setSha256(ResourceUtil.md5(ResourceUtil.getResource(uploadInfo.getAbsolutePath())));
        uploadInfo.setComplete(true);
        result.setComplete(true);
        UPLOAD_RESULT_MAP.remove(uploadInfo.getChunkId());
    }

    private FileOutputStream getTargetFileOutputStream(String targetFilePath) throws IOException {
        Resource resource = ResourceUtil.createResource(targetFilePath);
        return new FileOutputStream(resource.getFile().getAbsoluteFile());
    }

    private boolean isChunkUpload(String uploadType) {
        UploadProperties.Type type = UPLOAD_TYPE_MAP.get(uploadType);
        return null != type && null != type.getInuseChunk(this.uploadProperties) && type.getInuseChunk(this.uploadProperties).isEnabled();
    }
}

