/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.io.upload.read.config;

import cool.mtc.core.exception.StartupException;
import cool.mtc.io.upload.UploadProperties;
import cool.mtc.io.upload.read.interceptor.StaticResourceInterceptor;
import cool.mtc.io.upload.read.interceptor.StaticResourceInterceptorContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class StaticResourceReadConfigurer
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(StaticResourceReadConfigurer.class);
    private final UploadProperties uploadProperties;
    private final StaticResourceInterceptorContext staticResourceInterceptorContext;

    public void addInterceptors(InterceptorRegistry registry) {
        int order = 1;
        for (UploadProperties.Type type : this.uploadProperties.getTypes()) {
            UploadProperties.Read read = type.getRead();
            StaticResourceInterceptor interceptor = this.staticResourceInterceptorContext.getInterceptor(read.getPermission());
            if (null == interceptor) {
                String errMsg = String.format("Bean[%s]\u672a\u5b9a\u4e49", read.getPermission().getInterceptorBeanName());
                log.error(errMsg);
                throw new StartupException(errMsg);
            }
            registry.addInterceptor((HandlerInterceptor)interceptor).addPathPatterns(read.getRequestPathPatterns().toArray(new String[0])).order(order++);
        }
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        HashMap<String, List> resourcesMap = new HashMap<String, List>();
        for (UploadProperties.Type type : this.uploadProperties.getTypes()) {
            UploadProperties.Read read = type.getRead();
            ArrayList<String> locationList2 = new ArrayList<String>();
            String location = type.getInusePath(this.uploadProperties);
            locationList2.add(location);
            read.getRequestPathPatterns().forEach(path -> {
                if (resourcesMap.containsKey(path)) {
                    ((List)resourcesMap.get(path)).addAll(locationList2);
                } else {
                    resourcesMap.put((String)path, locationList2);
                }
            });
        }
        resourcesMap.forEach((path, locationList) -> registry.addResourceHandler(new String[]{path}).addResourceLocations(locationList.toArray(new String[0])));
    }

    @Autowired
    public StaticResourceReadConfigurer(UploadProperties uploadProperties, StaticResourceInterceptorContext staticResourceInterceptorContext) {
        this.uploadProperties = uploadProperties;
        this.staticResourceInterceptorContext = staticResourceInterceptorContext;
    }
}

