/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.io.util;

import cool.mtc.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ResourceUtils;

public abstract class ResourceUtil
extends ResourceUtils {
    private static final DefaultResourceLoader RESOURCE_LOADER = new DefaultResourceLoader();

    public static Resource getResource(String resourceLocation) {
        Resource resource = resourceLocation.startsWith("classpath:") ? ResourceUtil.getResourceByClasspath(resourceLocation) : (resourceLocation.startsWith("file:") ? ResourceUtil.getResourceByFilesystem(resourceLocation) : ResourceUtil.getResourceByFilesystem("file:" + resourceLocation));
        return resource;
    }

    public static Resource getResourceByClasspath(String resourceLocation) {
        return RESOURCE_LOADER.getResource(resourceLocation);
    }

    public static Resource getResourceByFilesystem(String resourceLocation) {
        return new FileSystemResource(resourceLocation.substring("file:".length()));
    }

    public static Resource createResource(String resourceLocation) throws IOException {
        Resource resource = resourceLocation.startsWith("classpath:") ? ResourceUtil.createResourceByClasspath(resourceLocation) : (resourceLocation.startsWith("file:") ? ResourceUtil.createResourceByFilesystem(resourceLocation) : ResourceUtil.createResourceByFilesystem("file:" + resourceLocation));
        return resource;
    }

    public static Resource createResourceByClasspath(String resourceLocation) throws IOException {
        String path = ResourceUtils.getURL((String)"classpath:").getPath();
        path = URLDecoder.decode(path, StandardCharsets.UTF_8.displayName());
        File file = new File(path, resourceLocation.substring("classpath:".length()));
        return ResourceUtil.getResourceByFile(file);
    }

    public static Resource createResourceByFilesystem(String resourceLocation) throws IOException {
        File file = new File(resourceLocation.substring("file:".length()));
        return ResourceUtil.getResourceByFile(file);
    }

    private static FileSystemResource getResourceByFile(File file) throws IOException {
        if (!file.exists()) {
            FileUtil.generateFile((String)file.getAbsolutePath());
        }
        return new FileSystemResource(file);
    }

    public static String plusUUIDFolder(String fileName) {
        return UUID.randomUUID().toString() + "/" + fileName;
    }

    public static String md5(Resource resource) throws IOException {
        InputStream inputStream = resource.getInputStream();
        try {
            String string = DigestUtils.md5Hex((InputStream)inputStream);
            return string;
        }
        finally {
            if (Collections.singletonList(inputStream).get(0) != null) {
                inputStream.close();
            }
        }
    }

    public static String sha256(Resource resource) throws IOException {
        InputStream inputStream = resource.getInputStream();
        try {
            String string = DigestUtils.sha256Hex((InputStream)inputStream);
            return string;
        }
        finally {
            if (Collections.singletonList(inputStream).get(0) != null) {
                inputStream.close();
            }
        }
    }
}

