/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.io.util;

import cool.mtc.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ResourceUtils;

public abstract class ResourceUtil
extends ResourceUtils {
    private static final DefaultResourceLoader RESOURCE_LOADER = new DefaultResourceLoader();

    public static Resource getResource(String resourceLocation) {
        Resource resource = resourceLocation.startsWith("classpath:") ? ResourceUtil.getResourceByClasspath(resourceLocation) : ResourceUtil.getResourceByFilesystem(resourceLocation);
        return resource;
    }

    public static Resource getResourceByClasspath(String resourceLocation) {
        return RESOURCE_LOADER.getResource(resourceLocation);
    }

    public static Resource getResourceByFilesystem(String resourceLocation) {
        if (resourceLocation.startsWith("file:")) {
            return new FileSystemResource(resourceLocation.substring("file:".length()));
        }
        return new FileSystemResource(resourceLocation);
    }

    public static Resource createResource(String resourceLocation) throws IOException {
        return ResourceUtil.createResource(resourceLocation, false);
    }

    public static Resource createResource(String resourceLocation, boolean alwaysCreate) throws IOException {
        Resource resource = resourceLocation.startsWith("classpath:") ? ResourceUtil.createResourceByClasspath(resourceLocation, alwaysCreate) : (resourceLocation.startsWith("file:") ? ResourceUtil.createResourceByFilesystem(resourceLocation, alwaysCreate) : ResourceUtil.createResourceByFilesystem(resourceLocation, alwaysCreate));
        return resource;
    }

    public static Resource createResourceByClasspath(String resourceLocation, boolean alwaysCreate) throws IOException {
        String path = ResourceUtils.getURL((String)"classpath:").getPath();
        path = URLDecoder.decode(path, StandardCharsets.UTF_8.displayName());
        File file = new File(path, resourceLocation.substring("classpath:".length()));
        return ResourceUtil.getResourceByFile(file, alwaysCreate);
    }

    public static Resource createResourceByFilesystem(String resourceLocation, boolean alwaysCreate) throws IOException {
        File file = resourceLocation.startsWith("file:") ? new File(resourceLocation.substring("file:".length())) : new File(resourceLocation);
        return ResourceUtil.getResourceByFile(file, alwaysCreate);
    }

    private static FileSystemResource getResourceByFile(File file, boolean alwaysCreate) throws IOException {
        if (alwaysCreate) {
            FileUtil.generateFile((String)file.getAbsolutePath());
        }
        if (!file.exists()) {
            FileUtil.generateFile((String)file.getAbsolutePath());
        }
        return new FileSystemResource(file);
    }

    public static String plusUUIDFolder(String fileName) {
        return UUID.randomUUID().toString() + "/" + fileName;
    }

    public static String md5(Resource resource) throws IOException {
        InputStream inputStream = resource.getInputStream();
        try {
            String string = DigestUtils.md5Hex((InputStream)inputStream);
            return string;
        }
        finally {
            if (Collections.singletonList(inputStream).get(0) != null) {
                inputStream.close();
            }
        }
    }

    public static String sha256(Resource resource) throws IOException {
        InputStream inputStream = resource.getInputStream();
        try {
            String string = DigestUtils.sha256Hex((InputStream)inputStream);
            return string;
        }
        finally {
            if (Collections.singletonList(inputStream).get(0) != null) {
                inputStream.close();
            }
        }
    }
}

