/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.io.zip;

import cool.mtc.core.util.StringUtil;
import cool.mtc.io.util.ResourceUtil;
import cool.mtc.io.zip.exception.ZipException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.springframework.stereotype.Component;

@Component
public class ZipTemplate {
    public File zip(String sourceFilePath, String targetFilePath) {
        return this.zip(sourceFilePath, targetFilePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File zip(String sourceFilePath, String targetFilePath, String nodeName) {
        File file;
        block6: {
            File sourceFile = ResourceUtil.getResource(sourceFilePath).getFile();
            File targetFile = ResourceUtil.createResource(targetFilePath).getFile();
            ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(targetFile.toPath(), new OpenOption[0]));
            try {
                this.zip(sourceFile, zipOutputStream, nodeName);
                file = targetFile;
                if (Collections.singletonList(zipOutputStream).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(zipOutputStream).get(0) != null) {
                        zipOutputStream.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new ZipException("\u521b\u5efa\u6587\u4ef6\u538b\u7f29\u5305\u5931\u8d25", (Throwable)ex);
                }
            }
            zipOutputStream.close();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip(File sourceFile, ZipOutputStream zipOutputStream, String nodeName) {
        block13: {
            String zipNodeName;
            String string = zipNodeName = StringUtil.isEmpty((String)nodeName) ? sourceFile.getName() : nodeName;
            if (sourceFile.isFile()) {
                try {
                    zipOutputStream.putNextEntry(new ZipEntry(zipNodeName));
                    FileInputStream inputStream = new FileInputStream(sourceFile);
                    try {
                        IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                        zipOutputStream.closeEntry();
                        break block13;
                    }
                    finally {
                        if (Collections.singletonList(inputStream).get(0) != null) {
                            inputStream.close();
                        }
                    }
                }
                catch (FileNotFoundException ex) {
                    String errMsg = String.format("\u6e90\u6587\u4ef6[%s]\u672a\u627e\u5230", sourceFile.getAbsolutePath());
                    throw new ZipException(errMsg);
                }
                catch (IOException ex) {
                    throw new ZipException("\u521b\u5efa\u6587\u4ef6\u538b\u7f29\u5305\u5931\u8d25", (Throwable)ex);
                }
            }
            File[] files = sourceFile.listFiles();
            if (null == files || files.length == 0) {
                try {
                    zipOutputStream.putNextEntry(new ZipEntry(zipNodeName + "/"));
                    zipOutputStream.closeEntry();
                }
                catch (IOException ex) {
                    throw new ZipException("\u521b\u5efa\u6587\u4ef6\u538b\u7f29\u5305\u5931\u8d25", (Throwable)ex);
                }
            } else {
                for (File file : files) {
                    this.zip(file, zipOutputStream, zipNodeName + "/" + file.getName());
                }
            }
        }
    }
}

