/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.minio;

import cool.mtc.minio.MinioProperties;
import io.minio.BucketExistsArgs;
import io.minio.DownloadObjectArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.UploadObjectArgs;

public class MinioTemplate {
    private final MinioProperties minioProperties;

    public MinioTemplate(MinioProperties minioProperties) {
        this.minioProperties = minioProperties;
    }

    public void upload(String bucketName, String fileName, String filePath) throws Exception {
        MinioClient client = this.getMinioClient();
        this.ensureBucketExist(bucketName);
        UploadObjectArgs args = (UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(bucketName)).object(fileName)).filename(filePath).build();
        client.uploadObject(args);
    }

    public void download(String bucketName, String fileName, String filePath) throws Exception {
        MinioClient client = this.getMinioClient();
        DownloadObjectArgs args = (DownloadObjectArgs)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)DownloadObjectArgs.builder().bucket(bucketName)).object(fileName)).filename(filePath).overwrite(true).build();
        client.downloadObject(args);
    }

    public void ensureBucketExist(String bucketName) throws Exception {
        MinioClient client = this.getMinioClient();
        boolean exist = client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
        if (exist) {
            return;
        }
        client.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
    }

    public MinioClient getMinioClient() {
        return MinioClient.builder().endpoint(this.minioProperties.getEndpoint()).credentials(this.minioProperties.getAccessKey(), this.minioProperties.getSecretKey()).build();
    }
}

