package cool.mtc.security;

import cool.mtc.security.auth.jwt.JwtAuthAdapter;
import cool.mtc.security.auth.password.PasswordAuthAdapter;
import cool.mtc.security.config.SecurityConfigurer;
import cool.mtc.security.handler.deny.AccessDeniedHandler;
import cool.mtc.security.handler.deny.AuthenticationEntryPoint;
import cool.mtc.security.handler.logout.LogoutHandler;
import cool.mtc.security.handler.logout.LogoutSuccessHandler;
import cool.mtc.security.plugin.jwt.JwtProperties;
import cool.mtc.security.plugin.jwt.JwtTemplate;
import cool.mtc.security.service.PermissionService;
import cool.mtc.security.service.SecurityService;
import cool.mtc.security.service.impl.DefaultSecurityServiceImpl;
import cool.mtc.security.service.impl.PermissionServiceImpl;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;

/**
 * @author 明河
 */
@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled = true)
@ConditionalOnProperty(value = "mtc.security.enabled", havingValue = "true", matchIfMissing = true)
@EnableConfigurationProperties({
        SecurityProperties.class,
        JwtProperties.class
})
@Import({
        SecurityConfigurer.class,
})
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class SecurityAutoConfiguration {
    private final SecurityProperties securityProperties;
    private final JwtProperties jwtProperties;

    @Bean
    public JwtTemplate jwtTemplate() {
        return new JwtTemplate(jwtProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value = SecurityService.class)
    public SecurityService securityService() {
        return new DefaultSecurityServiceImpl();
    }

    @Bean
    public PasswordAuthAdapter passwordAuthAdapter() {
        return new PasswordAuthAdapter(securityProperties, securityService(), jwtTemplate());
    }

    @Bean
    public JwtAuthAdapter jwtAuthAdapter() {
        return new JwtAuthAdapter(securityService(), jwtTemplate());
    }

    @Bean
    public AccessDeniedHandler accessDeniedHandler() {
        return new AccessDeniedHandler();
    }

    @Bean
    public AuthenticationEntryPoint authenticationEntryPoint() {
        return new AuthenticationEntryPoint();
    }

    @Bean
    public LogoutHandler logoutHandler() {
        return new LogoutHandler(securityService());
    }

    @Bean
    public LogoutSuccessHandler logoutSuccessHandler() {
        return new LogoutSuccessHandler();
    }

    @Bean(name = "ps")
    public PermissionService permissionService() {
        return new PermissionServiceImpl();
    }
}
