package cool.mtc.security.auth.password;

import cool.mtc.security.SecurityProperties;
import cool.mtc.security.handler.auth.password.PasswordAuthFailureHandler;
import cool.mtc.security.handler.auth.password.PasswordAuthSuccessHandler;
import cool.mtc.security.plugin.jwt.JwtTemplate;
import cool.mtc.security.service.SecurityService;
import lombok.RequiredArgsConstructor;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

/**
 * @author 明河
 */
@RequiredArgsConstructor
public class PasswordAuthAdapter extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private final SecurityProperties securityProperties;
    private final SecurityService securityService;
    private final JwtTemplate jwtTemplate;

    @Override
    public void configure(HttpSecurity builder) {
        PasswordAuthFilter filter = new PasswordAuthFilter(securityProperties);
        filter.setAuthenticationManager(builder.getSharedObject(AuthenticationManager.class));
        filter.setAuthenticationSuccessHandler(new PasswordAuthSuccessHandler(securityService, jwtTemplate));
        filter.setAuthenticationFailureHandler(new PasswordAuthFailureHandler());

        PasswordAuthProvider provider = new PasswordAuthProvider();
        provider.setSecurityService(securityService);
        provider.setPasswordEncoder(new BCryptPasswordEncoder());

        builder.authenticationProvider(provider).addFilterAt(filter, UsernamePasswordAuthenticationFilter.class);
    }
}
