package cool.mtc.security.auth.password;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;
import java.util.Optional;

/**
 * @author 明河
 */
@Getter
@EqualsAndHashCode(callSuper = true)
public class PasswordAuthToken extends AbstractAuthenticationToken {
    private final String username;
    private final String password;

    public PasswordAuthToken(String username, String password) {
        super(null);
        this.username = username;
        this.password = password;
        super.setAuthenticated(false);
    }

    public PasswordAuthToken(String username, String password, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.username = username;
        this.password = password;
        super.setAuthenticated(true);
    }

    @Override
    public Object getCredentials() {
        return Optional.ofNullable(this.getPassword()).orElse("");
    }

    @Override
    public Object getPrincipal() {
        return Optional.ofNullable(this.getUsername()).orElse("");
    }
}
