package cool.mtc.security.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import cool.mtc.core.result.Result;
import cool.mtc.core.result.ResultConstant;
import cool.mtc.web.util.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author 明河
 */
public interface HandleSupport {
    Logger LOGGER = LoggerFactory.getLogger(HandleSupport.class);
    ObjectMapper MAPPER = new ObjectMapper();

    default <T> void response(HttpServletResponse response, String message) {
        this.response(response,  ResultConstant.ERROR.newInstance().msg(message));
    }

    default <T> void response(HttpServletResponse response, Result<T> result) {
        try {
            HttpUtil.writeToResponse(response, MAPPER.writeValueAsString(result));
        } catch (JsonProcessingException ex) {
            LOGGER.error("对象序列化 - 失败 - 错误信息：{} - 对象信息: {}", ex.getMessage(), result.toString());
        } catch (IOException ex) {
            LOGGER.error("HTTP响应错误", ex);
        }
    }
}
