package cool.mtc.security.handler.auth;

import cool.mtc.core.result.ResultConstant;
import cool.mtc.security.exception.AuthException;
import cool.mtc.security.handler.HandleSupport;
import org.springframework.security.core.AuthenticationException;

import javax.servlet.http.HttpServletResponse;

/**
 * @author 明河
 */
public class AuthFailureHandler implements HandleSupport {

    public void fail(HttpServletResponse response, AuthenticationException ex) {
        AuthException authException = ex instanceof AuthException ? (AuthException) ex : new AuthException(ResultConstant.A0300);
        this.response(response, authException.getResult());
    }
}
