package cool.mtc.security.handler.auth;

import cool.mtc.core.result.ResultConstant;
import cool.mtc.security.constant.SecurityConstant;
import cool.mtc.security.data.model.UserDetails;
import cool.mtc.security.handler.HandleSupport;
import cool.mtc.security.plugin.jwt.JwtTemplate;
import cool.mtc.security.service.SecurityService;
import lombok.RequiredArgsConstructor;
import org.springframework.security.core.Authentication;

import javax.servlet.http.HttpServletResponse;

/**
 * @author 明河
 */
@RequiredArgsConstructor
public class AuthSuccessHandler implements HandleSupport {
    protected final SecurityService securityService;
    private final JwtTemplate jwtTemplate;

    public UserDetails success(HttpServletResponse response, Authentication authentication) {
        return this.success(response, authentication, false);
    }

    public UserDetails success(HttpServletResponse response, Authentication authentication, boolean createToken) {
        UserDetails userDetails = (UserDetails) authentication.getDetails();
        if (createToken) {
            this.createTokenAddToAllowListAndResponse(userDetails, response);
        }
        this.response(response, ResultConstant.OK);
        return userDetails;
    }

    /**
     * 创建token放入白名单中且加入响应头中
     */
    public void createTokenAddToAllowListAndResponse(UserDetails user, HttpServletResponse response) {
        String token = jwtTemplate.generate(user);
        // 把token放入白名单
        securityService.saveTokenToAllowList(token, user);
        // 在响应头中加入token
        response.addHeader(SecurityConstant.PARAM_TOKEN_KEY, token);
    }
}
