package cool.mtc.security.handler.auth.jwt;

import cool.mtc.security.handler.auth.AuthFailureHandler;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author 明河
 */
public class JwtAuthFailureHandler extends AuthFailureHandler implements AuthenticationFailureHandler {

    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException ex) {
        SecurityContextHolder.clearContext();
        this.fail(response, ex);
    }
}
