package cool.mtc.security.handler.auth.jwt;

import cool.mtc.security.auth.jwt.JwtAuthToken;
import cool.mtc.security.data.model.UserDetails;
import cool.mtc.security.handler.auth.AuthSuccessHandler;
import cool.mtc.security.plugin.jwt.JwtTemplate;
import cool.mtc.security.service.SecurityService;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author 明河
 */
public class JwtAuthSuccessHandler extends AuthSuccessHandler implements AuthenticationSuccessHandler {

    public JwtAuthSuccessHandler(SecurityService securityService, JwtTemplate jwtTemplate) {
        super(securityService, jwtTemplate);
    }

    @Override
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        SecurityContextHolder.getContext().setAuthentication(authentication);

        JwtAuthToken authToken = (JwtAuthToken) authentication;
        if (authToken.isExpired()) {
            super.createTokenAddToAllowListAndResponse((UserDetails) authToken.getDetails(), response);
            // 从白名单中移除旧的token
            securityService.removeTokenFromAllowList(authToken.getToken());
        }
    }
}
