/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.jwt;

import cool.mtc.security.auth.jwt.JwtAuthFilter;
import cool.mtc.security.auth.jwt.JwtAuthProvider;
import cool.mtc.security.handler.auth.jwt.JwtAuthFailureHandler;
import cool.mtc.security.handler.auth.jwt.JwtAuthSuccessHandler;
import cool.mtc.security.plugin.jwt.JwtTemplate;
import cool.mtc.security.service.SecurityService;
import javax.servlet.Filter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class JwtAuthAdapter
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private final SecurityService securityService;
    private final JwtTemplate jwtTemplate;

    public void configure(HttpSecurity builder) {
        JwtAuthFilter filter = new JwtAuthFilter();
        filter.setAuthenticationManager((AuthenticationManager)builder.getSharedObject(AuthenticationManager.class));
        filter.setAuthenticationSuccessHandler(new JwtAuthSuccessHandler(this.securityService, this.jwtTemplate));
        filter.setAuthenticationFailureHandler(new JwtAuthFailureHandler());
        JwtAuthProvider provider = new JwtAuthProvider();
        provider.setSecurityService(this.securityService);
        provider.setJwtTemplate(this.jwtTemplate);
        builder.authenticationProvider((AuthenticationProvider)provider).addFilterAt((Filter)filter, UsernamePasswordAuthenticationFilter.class);
    }

    public JwtAuthAdapter(SecurityService securityService, JwtTemplate jwtTemplate) {
        this.securityService = securityService;
        this.jwtTemplate = jwtTemplate;
    }
}

