/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import cool.mtc.core.result.Result;
import cool.mtc.core.result.ResultConstant;
import cool.mtc.web.util.HttpUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HandleSupport {
    public static final Logger LOGGER = LoggerFactory.getLogger(HandleSupport.class);
    public static final ObjectMapper MAPPER = new ObjectMapper();

    default public <T> void response(HttpServletResponse response, String message) {
        this.response(response, ResultConstant.ERROR.newInstance().msg(message));
    }

    default public <T> void response(HttpServletResponse response, Result<T> result) {
        try {
            HttpUtil.writeToResponse((HttpServletResponse)response, (String)MAPPER.writeValueAsString(result));
        }
        catch (JsonProcessingException ex) {
            LOGGER.error("\u5bf9\u8c61\u5e8f\u5217\u5316 - \u5931\u8d25 - \u9519\u8bef\u4fe1\u606f\uff1a{} - \u5bf9\u8c61\u4fe1\u606f: {}", (Object)ex.getMessage(), (Object)result.toString());
        }
        catch (IOException ex) {
            LOGGER.error("HTTP\u54cd\u5e94\u9519\u8bef", (Throwable)ex);
        }
    }
}

