/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.handler.auth;

import cool.mtc.core.result.ResultConstant;
import cool.mtc.security.data.model.UserDetails;
import cool.mtc.security.handler.HandleSupport;
import cool.mtc.security.plugin.jwt.JwtTemplate;
import cool.mtc.security.service.SecurityService;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;

public class AuthSuccessHandler
implements HandleSupport {
    protected final SecurityService securityService;
    private final JwtTemplate jwtTemplate;

    public UserDetails success(HttpServletResponse response, Authentication authentication) {
        return this.success(response, authentication, false);
    }

    public UserDetails success(HttpServletResponse response, Authentication authentication, boolean createToken) {
        UserDetails userDetails = (UserDetails)authentication.getDetails();
        if (createToken) {
            this.createTokenAddToAllowListAndResponse(userDetails, response);
        }
        this.response(response, ResultConstant.OK);
        return userDetails;
    }

    public void createTokenAddToAllowListAndResponse(UserDetails user, HttpServletResponse response) {
        String token = this.jwtTemplate.generate(user);
        this.securityService.saveTokenToAllowList(token, user);
        response.addHeader("Authorization", token);
    }

    public AuthSuccessHandler(SecurityService securityService, JwtTemplate jwtTemplate) {
        this.securityService = securityService;
        this.jwtTemplate = jwtTemplate;
    }
}

