/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.service.impl;

import cool.mtc.core.exception.CustomException;
import cool.mtc.core.result.ResultConstant;
import cool.mtc.security.data.model.UserDetails;
import cool.mtc.security.service.PermissionService;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class PermissionServiceImpl
implements PermissionService {
    private static final Map<String, Pattern> PATTERN_MAP = new HashMap<String, Pattern>();

    @Override
    public boolean hasPermission(String permission) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        UserDetails user = (UserDetails)authentication.getDetails();
        boolean hasPermission = false;
        for (String item : user.getPermissionList()) {
            if (item.contains("*")) {
                if (!PATTERN_MAP.containsKey(item)) {
                    PATTERN_MAP.put(item, Pattern.compile(item.replace("*", ".*")));
                }
                hasPermission = PATTERN_MAP.get(item).matcher(permission).matches();
            } else {
                hasPermission = item.equals(permission);
            }
            if (!hasPermission) continue;
            break;
        }
        if (hasPermission) {
            return true;
        }
        throw new CustomException(ResultConstant.A0301);
    }
}

