package cool.mtc.security.handler.logout;

import cool.mtc.core.util.StringUtil;
import cool.mtc.security.constant.SecurityConstant;
import cool.mtc.security.handler.HandleSupport;
import cool.mtc.security.service.SecurityService;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author 明河
 * <p>
 * 登出时的处理
 */
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class LogoutHandler implements HandleSupport, org.springframework.security.web.authentication.logout.LogoutHandler {
    private final SecurityService securityService;

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        String token = SecurityConstant.getTokenFromRequest(request);
        if (StringUtil.isEmpty(token)) {
            return;
        }
        securityService.removeTokenFromAllowList(token);
    }
}
