/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.config;

import cool.mtc.security.SecurityProperties;
import cool.mtc.security.auth.jwt.JwtAuthAdapter;
import cool.mtc.security.auth.password.PasswordAuthAdapter;
import cool.mtc.security.handler.deny.AuthenticationEntryPoint;
import cool.mtc.security.handler.logout.LogoutHandler;
import cool.mtc.security.handler.logout.LogoutSuccessHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.access.AccessDeniedHandler;

@Configuration
public class SecurityConfigurer
extends WebSecurityConfigurerAdapter {
    private final SecurityProperties securityProperties;
    private final LogoutHandler logoutHandler;
    private final LogoutSuccessHandler logoutSuccessHandler;
    private final AuthenticationEntryPoint authenticationEntryPoint;
    private final cool.mtc.security.handler.deny.AccessDeniedHandler accessDeniedHandler;
    private final PasswordAuthAdapter passwordAuthAdapter;
    private final JwtAuthAdapter jwtAuthAdapter;

    protected void configure(HttpSecurity http) throws Exception {
        http.csrf().disable();
        if (this.securityProperties.isCors()) {
            http.cors();
        } else {
            http.cors().disable();
        }
        http.apply((SecurityConfigurerAdapter)this.passwordAuthAdapter);
        http.apply((SecurityConfigurerAdapter)this.jwtAuthAdapter);
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(this.securityProperties.getAuthUrls())).authenticated();
        http.logout().logoutUrl(this.securityProperties.getLogoutUrl()).addLogoutHandler((org.springframework.security.web.authentication.logout.LogoutHandler)this.logoutHandler).logoutSuccessHandler((org.springframework.security.web.authentication.logout.LogoutSuccessHandler)this.logoutSuccessHandler);
        http.exceptionHandling().authenticationEntryPoint((org.springframework.security.web.AuthenticationEntryPoint)this.authenticationEntryPoint).accessDeniedHandler((AccessDeniedHandler)this.accessDeniedHandler);
    }

    public void configure(WebSecurity web) {
        if (this.securityProperties.getIgnoreUrls().length > 0) {
            web.ignoring().antMatchers(this.securityProperties.getIgnoreUrls());
        }
    }

    @Autowired
    public SecurityConfigurer(SecurityProperties securityProperties, LogoutHandler logoutHandler, LogoutSuccessHandler logoutSuccessHandler, AuthenticationEntryPoint authenticationEntryPoint, cool.mtc.security.handler.deny.AccessDeniedHandler accessDeniedHandler, PasswordAuthAdapter passwordAuthAdapter, JwtAuthAdapter jwtAuthAdapter) {
        this.securityProperties = securityProperties;
        this.logoutHandler = logoutHandler;
        this.logoutSuccessHandler = logoutSuccessHandler;
        this.authenticationEntryPoint = authenticationEntryPoint;
        this.accessDeniedHandler = accessDeniedHandler;
        this.passwordAuthAdapter = passwordAuthAdapter;
        this.jwtAuthAdapter = jwtAuthAdapter;
    }
}

