/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import cool.mtc.core.result.Result;
import cool.mtc.core.result.ResultConstant;
import cool.mtc.web.component.I18nHandler;
import cool.mtc.web.util.HttpUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public interface HandleSupport {
    public static final Logger LOGGER = LoggerFactory.getLogger(HandleSupport.class);
    public static final ObjectMapper MAPPER = new ObjectMapper();

    default public <T> void response(String message) {
        this.response(null, message);
    }

    default public <T> void response(Result<T> result) {
        this.response(null, result);
    }

    default public <T> void response(I18nHandler i18nHandler, String message) {
        this.response(i18nHandler, ResultConstant.ERROR.newInstance().msg(message));
    }

    default public <T> void response(I18nHandler i18nHandler, Result<T> result) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        HttpServletResponse response = attributes.getResponse();
        String requestUri = request.getRequestURI();
        try {
            if (null != i18nHandler) {
                String msg = i18nHandler.getMessage(result.getMsg(), new Object[0]);
                result.setMsg(msg);
            }
            String content = MAPPER.writeValueAsString(result);
            HttpUtil.writeToResponse((HttpServletResponse)response, (String)content);
            LOGGER.info("\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", (Object)requestUri, (Object)content);
        }
        catch (JsonProcessingException ex) {
            LOGGER.error("\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5bf9\u8c61\u5e8f\u5217\u5316 - \u5931\u8d25 - \u9519\u8bef\u4fe1\u606f\uff1a{} - \u5bf9\u8c61\u4fe1\u606f: {}", new Object[]{requestUri, ex.getMessage(), result.toString()});
        }
        catch (IOException ex) {
            LOGGER.error("\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0cHTTP\u54cd\u5e94\u9519\u8bef", (Object)requestUri, (Object)ex);
        }
    }
}

