package cool.mtc.security.handler.deny;

import cool.mtc.core.result.ResultConstant;
import cool.mtc.security.handler.HandleSupport;
import cool.mtc.web.component.I18nHandler;
import lombok.RequiredArgsConstructor;
import org.springframework.security.core.AuthenticationException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author 明河
 * <p>
 * 匿名用户访问无权限资源时的异常
 */
@RequiredArgsConstructor
public class AuthenticationEntryPoint implements HandleSupport, org.springframework.security.web.AuthenticationEntryPoint {
    private final I18nHandler i18nHandler;

    @Override
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException ex) {
        this.response(i18nHandler, ResultConstant.A0301);
    }
}
