/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.handler.auth.jwt;

import cool.mtc.security.auth.jwt.JwtAuthToken;
import cool.mtc.security.data.model.UserDetails;
import cool.mtc.security.handler.auth.AuthSuccessHandler;
import cool.mtc.security.plugin.jwt.JwtTemplate;
import cool.mtc.security.service.SecurityService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

public class JwtAuthSuccessHandler
extends AuthSuccessHandler
implements AuthenticationSuccessHandler {
    public JwtAuthSuccessHandler(SecurityService securityService, JwtTemplate jwtTemplate) {
        super(securityService, jwtTemplate);
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        SecurityContextHolder.getContext().setAuthentication(authentication);
        JwtAuthToken authToken = (JwtAuthToken)authentication;
        if (authToken.isExpired()) {
            super.createTokenAddToAllowListAndResponse((UserDetails)authToken.getDetails());
            this.securityService.removeTokenFromAllowList(authToken.getToken());
        }
    }
}

