package cool.mtc.security.auth.jwt;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;

/**
 * @author 明河
 */
@Getter
@EqualsAndHashCode(callSuper = true)
public class JwtAuthToken extends AbstractAuthenticationToken {
    private final String token;
    private boolean expired = false;

    public JwtAuthToken(String token) {
        super(null);
        this.token = token;
        super.setAuthenticated(false);
    }

    public JwtAuthToken(String token, boolean expired, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.token = token;
        this.expired = expired;
        super.setAuthenticated(true);
    }

    @Override
    public Object getCredentials() {
        return null;
    }

    @Override
    public Object getPrincipal() {
        return null;
    }
}
