package cool.mtc.security.service;

import cool.mtc.security.data.model.UserDetails;

/**
 * @author 明河
 */
public interface SecurityService {

    // region Token处理

    boolean isTokenInAllowList(String token);

    void saveTokenToAllowList(String token, UserDetails user);

    void removeTokenFromAllowList(String token);

    // endregion

    UserDetails loadByUsernameAndAuthType(String username, String authType);

    UserDetails loadByUserIdAndOrgIdAndAuthType(Object userId, Object orgId, String authType);

    /**
     * 验证码是否错误
     */
    boolean isVerifyCodeError(Object verifyCode);

    /**
     * 登录成功日志
     */
    void loginSuccessLog(UserDetails userDetails);
}
