/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.password;

import java.util.Collection;
import java.util.Optional;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class PasswordAuthToken
extends AbstractAuthenticationToken {
    private final String username;
    private final String password;

    public PasswordAuthToken(String username, String password) {
        super(null);
        this.username = username;
        this.password = password;
        super.setAuthenticated(false);
    }

    public PasswordAuthToken(String username, String password, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.username = username;
        this.password = password;
        super.setAuthenticated(true);
    }

    public Object getCredentials() {
        return Optional.ofNullable(this.getPassword()).orElse("");
    }

    public Object getPrincipal() {
        return Optional.ofNullable(this.getUsername()).orElse("");
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PasswordAuthToken)) {
            return false;
        }
        PasswordAuthToken other = (PasswordAuthToken)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PasswordAuthToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }
}

