package cool.mtc.security.handler.auth;

import cool.mtc.core.result.ResultConstant;
import cool.mtc.security.exception.AuthException;
import cool.mtc.security.handler.HandleSupport;
import cool.mtc.web.component.I18nHandler;
import lombok.RequiredArgsConstructor;
import org.springframework.security.core.AuthenticationException;

import javax.servlet.http.HttpServletResponse;

/**
 * @author 明河
 */
@RequiredArgsConstructor
public class AuthFailureHandler implements HandleSupport {
    public final I18nHandler i18nHandler;

    public void fail(AuthenticationException ex) {
        AuthException authException = ex instanceof AuthException ? (AuthException) ex : new AuthException(ResultConstant.A0300);
        this.response(i18nHandler, authException.getResult());
    }
}
