package cool.mtc.security.handler.deny;

import cool.mtc.core.result.ResultConstant;
import cool.mtc.security.handler.HandleSupport;
import cool.mtc.web.component.I18nHandler;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.AccessDeniedException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author 明河
 * <p>
 * 认证用户访问无权限资源时的异常
 */
@RequiredArgsConstructor
public class AccessDeniedHandler implements HandleSupport, org.springframework.security.web.access.AccessDeniedHandler {
    private final I18nHandler i18nHandler;

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException ex) {
        this.response(i18nHandler, ResultConstant.A0301);
    }
}
