/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.jwt;

import cool.mtc.core.result.Result;
import cool.mtc.core.result.ResultConstant;
import cool.mtc.security.auth.jwt.JwtAuthToken;
import cool.mtc.security.data.model.UserDetails;
import cool.mtc.security.exception.AuthException;
import cool.mtc.security.plugin.jwt.JwtTemplate;
import cool.mtc.security.service.SecurityService;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import java.util.Optional;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;

public class JwtAuthProvider
implements AuthenticationProvider,
InitializingBean {
    private SecurityService securityService;
    private JwtTemplate jwtTemplate;

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.securityService, (String)"A SecurityService Bean Must Be Set");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Claims claims;
        String token = ((JwtAuthToken)authentication).getToken();
        boolean isTokenExpired = false;
        try {
            claims = this.parseToken(token);
        }
        catch (ExpiredJwtException ex) {
            claims = ex.getClaims();
            isTokenExpired = true;
        }
        this.handleCheckTokenInWhiteList(token);
        UserDetails user = Optional.ofNullable(this.getUserDetailsByToken(claims)).orElseThrow(() -> new AuthException((Result<Object>)ResultConstant.A0301));
        this.handleCheckUserStatus(user);
        JwtAuthToken authToken = new JwtAuthToken(token, isTokenExpired, user.getAuthorities());
        authToken.setDetails(user);
        return authToken;
    }

    public boolean supports(Class<?> aClass) {
        return JwtAuthToken.class.isAssignableFrom(aClass);
    }

    private Claims parseToken(String token) throws ExpiredJwtException {
        try {
            return this.jwtTemplate.parse(token);
        }
        catch (ExpiredJwtException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AuthException((Result<Object>)ResultConstant.A0301);
        }
    }

    private UserDetails getUserDetailsByToken(Claims claims) {
        try {
            Object userId = claims.get((Object)"userId");
            Object orgId = claims.get((Object)"orgId");
            Object authType = claims.get((Object)"authType");
            return this.securityService.loadByUserIdAndOrgIdAndAuthType(userId, orgId, authType.toString());
        }
        catch (NullPointerException ex) {
            throw new AuthException((Result<Object>)ResultConstant.A0301);
        }
    }

    private void handleCheckTokenInWhiteList(String token) {
        if (this.securityService.isTokenInAllowList(token)) {
            return;
        }
        throw new AuthException((Result<Object>)ResultConstant.A0311);
    }

    private void handleCheckUserStatus(UserDetails user) {
        if (user.isEnabled()) {
            return;
        }
        throw new AuthException((Result<Object>)ResultConstant.A0200.newInstance(), "login.status.error");
    }

    @Autowired
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Autowired
    public void setJwtTemplate(JwtTemplate jwtTemplate) {
        this.jwtTemplate = jwtTemplate;
    }
}

