/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.handler.auth;

import cool.mtc.core.result.Result;
import cool.mtc.core.result.ResultConstant;
import cool.mtc.security.data.model.UserDetails;
import cool.mtc.security.handler.HandleSupport;
import cool.mtc.security.plugin.jwt.JwtTemplate;
import cool.mtc.security.service.SecurityService;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AuthSuccessHandler
implements HandleSupport {
    protected final SecurityService securityService;
    private final JwtTemplate jwtTemplate;

    public UserDetails success(Authentication authentication) {
        return this.success(authentication, false);
    }

    public UserDetails success(Authentication authentication, boolean createToken) {
        UserDetails userDetails = (UserDetails)authentication.getDetails();
        if (createToken) {
            String token = this.createTokenAddToAllowListAndResponse(userDetails);
            this.response(Result.ofData((Object)token));
        } else {
            this.response(ResultConstant.OK);
        }
        return userDetails;
    }

    public String createTokenAddToAllowListAndResponse(UserDetails user) {
        String token = this.jwtTemplate.generate(user);
        this.securityService.saveTokenToAllowList(token, user);
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletResponse response = attributes.getResponse();
        if (null != response) {
            response.addHeader("Authorization", token);
        }
        return token;
    }

    public AuthSuccessHandler(SecurityService securityService, JwtTemplate jwtTemplate) {
        this.securityService = securityService;
        this.jwtTemplate = jwtTemplate;
    }
}

