/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.plugin.jwt;

import cool.mtc.core.util.DateUtil;
import cool.mtc.security.data.model.UserDetails;
import cool.mtc.security.plugin.jwt.JwtProperties;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.impl.DefaultClaims;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;

public class JwtTemplate {
    private final JwtProperties jwtProperties;

    public String generate(UserDetails user) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("userId", user.getUserId());
        data.put("orgId", user.getOrgId());
        data.put("authType", user.getAuthType());
        return this.generate(data);
    }

    public String generate(Map<String, Object> data) {
        return Jwts.builder().addClaims((Map)this.handleClaimsData(data)).signWith(this.jwtProperties.getSignatureAlgorithm(), this.getKey()).compact();
    }

    public Claims parse(String token) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException {
        return (Claims)Jwts.parser().setSigningKey(this.getKey()).parseClaimsJws(token).getBody();
    }

    private Claims handleClaimsData(Map<String, Object> data) {
        DefaultClaims claims = new DefaultClaims();
        claims.putAll(data);
        LocalDateTime now = LocalDateTime.now();
        claims.setIssuedAt(DateUtil.localDateTimeToDate((LocalDateTime)now));
        LocalDateTime expiredDateTime = now.plusMinutes(this.jwtProperties.getValidDuration().toMinutes());
        claims.setExpiration(DateUtil.localDateTimeToDate((LocalDateTime)expiredDateTime));
        return claims;
    }

    private Key getKey() {
        byte[] key_bytes = this.jwtProperties.getKey().getBytes(StandardCharsets.UTF_8);
        return new SecretKeySpec(key_bytes, this.jwtProperties.getSignatureAlgorithm().getJcaName());
    }

    public JwtTemplate(JwtProperties jwtProperties) {
        this.jwtProperties = jwtProperties;
    }
}

