package cool.mtc.security.constant;


import cool.mtc.core.util.StringUtil;

import javax.servlet.http.HttpServletRequest;

/**
 * @author 明河
 */
public abstract class SecurityConstant {
    public static final String PARAM_TOKEN_KEY = "Authorization";
    public static final String PARAM_TOKEN_PREFIX = "Bearer ";

    /**
     * 从请求中获取token
     */
    public static String getTokenFromRequest(HttpServletRequest request) {
        String token = request.getHeader(PARAM_TOKEN_KEY);
        if (StringUtil.isEmpty(token) || !token.startsWith(PARAM_TOKEN_PREFIX)) {
            return null;
        }
        return token.replaceFirst(PARAM_TOKEN_PREFIX, StringUtil.EMPTY);
    }
}
