package cool.mtc.security.handler.auth.password;

import cool.mtc.security.data.model.UserDetailsSupport;
import cool.mtc.security.handler.auth.AuthSuccessHandler;
import cool.mtc.security.plugin.jwt.JwtTemplate;
import cool.mtc.security.service.SecurityService;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author 明河
 */
public class PasswordAuthSuccessHandler extends AuthSuccessHandler implements AuthenticationSuccessHandler {

    public PasswordAuthSuccessHandler(SecurityService securityService, JwtTemplate jwtTemplate) {
        super(securityService, jwtTemplate);
    }

    @Override
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        UserDetailsSupport userDetails = this.success(authentication, true);
        // 登录成功
        securityService.authSuccess(userDetails);
    }
}
