package cool.mtc.security.handler.logout;

import cool.mtc.core.result.ResultConstant;
import cool.mtc.security.data.model.UserDetailsSupport;
import cool.mtc.security.handler.HandleSupport;
import cool.mtc.security.service.SecurityService;
import cool.mtc.web.component.I18nHandler;
import lombok.RequiredArgsConstructor;
import org.springframework.security.core.Authentication;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author 明河
 * <p>
 * 登出成功后的处理
 */
@RequiredArgsConstructor
public class LogoutSuccessHandler implements HandleSupport, org.springframework.security.web.authentication.logout.LogoutSuccessHandler {
    private final I18nHandler i18nHandler;
    private final SecurityService securityService;

    @Override
    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.response(i18nHandler, ResultConstant.OK);

        UserDetailsSupport userSupport = (UserDetailsSupport) authentication.getDetails();
        securityService.logoutSuccess(userSupport);
    }
}
