package cool.mtc.security.service;

import cool.mtc.security.auth.custom.CustomAuthFormSupport;
import cool.mtc.security.data.model.UserDetailsSupport;

import javax.servlet.http.HttpServletRequest;

/**
 * @author 明河
 */
public interface SecurityService {

    // region Token处理

    boolean isTokenInAllowList(String token);

    void saveTokenToAllowList(String token, UserDetailsSupport userSupport);

    void removeTokenFromAllowList(String token);

    // endregion

    UserDetailsSupport loadByUsernameAndAuthType(String username, String authType);

    UserDetailsSupport loadByUserIdAndOrgIdAndAuthType(Object userId, Object orgId, String authType);

    /**
     * 验证码是否错误
     */
    default boolean isVerifyCodeError(Object verifyCode) {
        return false;
    }

    /**
     * 自定义方式登录时丛请求中获取表单的方法
     */
    CustomAuthFormSupport getCustomForm(HttpServletRequest request);

    /**
     * 自定义方式登录时登录验证方法
     * 此方法应验证是否登录成功，并且保证返回不为空的UserDetails
     */
    UserDetailsSupport loadByCustomForm(CustomAuthFormSupport form);

    /**
     * 认证成功之后调用的方法
     * 此方法在响应客户端请求后执行
     */
    default void authSuccess(UserDetailsSupport userSupport) {
    }

    /**
     * 登出成功之后
     * 此方法在响应客户端请求后执行
     */
    default void logoutSuccess(UserDetailsSupport userSupport) {
    }
}
