/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.custom;

import cool.mtc.security.SecurityProperties;
import cool.mtc.security.auth.custom.CustomAuthFormSupport;
import cool.mtc.security.auth.custom.CustomAuthToken;
import cool.mtc.security.service.SecurityService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class CustomAuthFilter
extends AbstractAuthenticationProcessingFilter {
    private final SecurityService securityService;

    public CustomAuthFilter(SecurityProperties securityProperties, SecurityService securityService) {
        super((RequestMatcher)new AntPathRequestMatcher(securityProperties.getLoginUrlByCustom(), HttpMethod.POST.name()));
        this.securityService = securityService;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        CustomAuthFormSupport form = this.securityService.getCustomForm(request);
        CustomAuthToken token = new CustomAuthToken(form);
        this.setDetails(request, token);
        return super.getAuthenticationManager().authenticate((Authentication)token);
    }

    private void setDetails(HttpServletRequest request, CustomAuthToken token) {
        token.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }
}

