/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.custom;

import cool.mtc.security.auth.custom.CustomAuthFormSupport;
import cool.mtc.security.auth.custom.CustomAuthToken;
import cool.mtc.security.data.model.UserDetailsSupport;
import cool.mtc.security.service.SecurityService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;

public class CustomAuthProvider
implements AuthenticationProvider,
InitializingBean {
    private SecurityService securityService;

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.securityService, (String)"A SecurityService Bean Must Be Set");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        CustomAuthFormSupport form = (CustomAuthFormSupport)authentication.getPrincipal();
        UserDetailsSupport user = this.securityService.loadByCustomForm(form);
        CustomAuthToken token = new CustomAuthToken(form, user.getAuthorities());
        token.setDetails(user);
        return token;
    }

    public boolean supports(Class<?> aClass) {
        return CustomAuthToken.class.isAssignableFrom(aClass);
    }

    @Autowired
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

