/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.password;

import com.fasterxml.jackson.databind.ObjectMapper;
import cool.mtc.core.result.Result;
import cool.mtc.core.result.ResultConstant;
import cool.mtc.core.util.StringUtil;
import cool.mtc.security.SecurityProperties;
import cool.mtc.security.auth.password.PasswordAuthForm;
import cool.mtc.security.auth.password.PasswordAuthToken;
import cool.mtc.security.exception.AuthException;
import cool.mtc.security.service.SecurityService;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class PasswordAuthFilter
extends AbstractAuthenticationProcessingFilter {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final SecurityService securityService;

    public PasswordAuthFilter(SecurityProperties securityProperties, SecurityService securityService) {
        super((RequestMatcher)new AntPathRequestMatcher(securityProperties.getLoginUrlByPassword(), HttpMethod.POST.name()));
        this.securityService = securityService;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        PasswordAuthForm form = this.handleCheckParams(request);
        if (this.securityService.isVerifyCodeError(form.getVerifyCode())) {
            throw new AuthException((Result<Object>)ResultConstant.A0130, "login.verify_code.error");
        }
        PasswordAuthToken token = new PasswordAuthToken(form.getUsername(), form.getPassword());
        this.setDetails(request, token);
        return super.getAuthenticationManager().authenticate((Authentication)token);
    }

    private PasswordAuthForm handleCheckParams(HttpServletRequest request) {
        PasswordAuthForm form;
        try {
            form = (PasswordAuthForm)MAPPER.readValue((InputStream)request.getInputStream(), PasswordAuthForm.class);
        }
        catch (IOException ex) {
            throw new AuthException((Result<Object>)ResultConstant.A0402, "login.param.error");
        }
        if (StringUtil.isEmpty((String)form.getUsername())) {
            throw new AuthException((Result<Object>)ResultConstant.A0410, "login.username.required");
        }
        if (StringUtil.isEmpty((String)form.getPassword())) {
            throw new AuthException((Result<Object>)ResultConstant.A0410, "login.password.required");
        }
        return form;
    }

    private void setDetails(HttpServletRequest request, PasswordAuthToken token) {
        token.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }
}

