/*
 * Decompiled with CFR 0.152.
 */
package cool.mtc.security.auth.password;

import cool.mtc.core.result.Result;
import cool.mtc.core.result.ResultConstant;
import cool.mtc.security.auth.password.PasswordAuthToken;
import cool.mtc.security.data.model.UserDetailsSupport;
import cool.mtc.security.exception.AuthException;
import cool.mtc.security.service.SecurityService;
import java.util.Optional;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;

public class PasswordAuthProvider
implements AuthenticationProvider,
InitializingBean {
    private SecurityService securityService;
    private PasswordEncoder passwordEncoder;

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.securityService, (String)"A SecurityService Bean Must Be Set");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getPrincipal().toString();
        String password = authentication.getCredentials().toString();
        UserDetailsSupport user = Optional.ofNullable(this.securityService.loadByUsernameAndAuthType(username, "PASSWORD")).orElseThrow(() -> new AuthException((Result<Object>)ResultConstant.A0201, "login.username_or_password.error"));
        this.handleCheckPasswordCorrect(user, password);
        this.handleCheckUserStatus(user);
        PasswordAuthToken token = new PasswordAuthToken(user.getUsername(), user.getPassword(), user.getAuthorities());
        token.setDetails(user);
        return token;
    }

    public boolean supports(Class<?> aClass) {
        return PasswordAuthToken.class.isAssignableFrom(aClass);
    }

    private void handleCheckPasswordCorrect(UserDetailsSupport user, String inputPassword) {
        if (this.passwordEncoder.matches((CharSequence)inputPassword, user.getPassword())) {
            return;
        }
        throw new AuthException((Result<Object>)ResultConstant.A0210, "login.username_or_password.error");
    }

    private void handleCheckUserStatus(UserDetailsSupport user) {
        if (user.isEnabled()) {
            return;
        }
        throw new AuthException((Result<Object>)ResultConstant.A0200, "login.status.disable");
    }

    @Autowired
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Autowired
    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }
}

