package cool.mtc.security;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author 明河
 */
@Data
@ConfigurationProperties(prefix = "mtc.security")
public class SecurityProperties {

    /**
     * 是否启用
     * 默认启用
     */
    private boolean enabled = true;

    /**
     * 是否启用跨域
     * 默认不启用
     */
    private boolean cors = false;

    /**
     * 需要验证的Ant Patterns
     */
    private String[] authUrls = {"/**"};

    /**
     * 忽略验证的Ant Patterns
     */
    private String[] ignoreUrls = {};

    /**
     * 用户名密码登录地址
     */
    private String loginUrlByPassword = "/api/login/password";

    /**
     * 自定义登录地址
     */
    private String loginUrlByCustom = "/api/login/custom";

    /**
     * 登出地址
     */
    private String logoutUrl = "/api/logout";
}
