package cool.mtc.security.auth.custom;

import cool.mtc.security.SecurityProperties;
import cool.mtc.security.auth.jwt.JwtAuthFilter;
import cool.mtc.security.handler.auth.custom.CustomAuthFailureHandler;
import cool.mtc.security.handler.auth.custom.CustomAuthSuccessHandler;
import cool.mtc.security.service.SecurityService;
import lombok.RequiredArgsConstructor;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.DefaultSecurityFilterChain;

/**
 * @author 明河
 */
@RequiredArgsConstructor
public class CustomAuthAdapter extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private final SecurityProperties securityProperties;
    private final SecurityService securityService;
    private final CustomAuthSuccessHandler customAuthSuccessHandler;
    private final CustomAuthFailureHandler customAuthFailureHandler;

    @Override
    public void configure(HttpSecurity http) {
        CustomAuthFilter filter = new CustomAuthFilter(securityProperties, securityService);
        filter.setAuthenticationManager(http.getSharedObject(AuthenticationManager.class));
        filter.setAuthenticationSuccessHandler(customAuthSuccessHandler);
        filter.setAuthenticationFailureHandler(customAuthFailureHandler);

        CustomAuthProvider provider = new CustomAuthProvider();
        provider.setSecurityService(securityService);

        http.authenticationProvider(provider)
                .addFilterBefore(filter, JwtAuthFilter.class);
    }
}
